/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.taskman.toolkit.dialog;

import filenet.vw.apps.taskman.VWTaskCore;
import filenet.vw.apps.taskman.VWTaskUtil;
import filenet.vw.apps.taskman.pa.resources.VWResource;
import filenet.vw.apps.taskman.toolkit.dialog.IVWTaskWizard;
import filenet.vw.apps.taskman.toolkit.dialog.IVWTaskWizardControl;
import filenet.vw.apps.taskman.toolkit.dialog.IVWTaskWizardPanel;
import filenet.vw.apps.taskman.toolkit.dialog.VWTaskWizardDialog;
import filenet.vw.apps.taskman.toolkit.dialog.VWTaskWizardListener;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.VWAccessibilityHelper;
import filenet.vw.toolkit.utils.VWHelp;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class VWTaskWizardMainPanel
extends JPanel
implements ActionListener,
IVWTaskWizard {
    private List m_panelList = null;
    private int m_nPanelIndex = 0;
    private boolean m_bConfirmOnCancel = true;
    private boolean m_bSummaryDisplayed = false;
    private VWTaskWizardDialog m_mainFrame = null;
    private VWTaskWizardListener m_wizardListener = null;
    private boolean m_bSystemExitOnClose = false;
    private JTextArea m_instructionsArea = null;
    private JScrollPane m_instructionsScrollPane = null;
    private JPanel m_mainPanel = null;
    private IVWTaskWizardPanel m_summaryPanel;
    private CardLayout m_cardLayout = null;
    private JButton m_backButton = null;
    private JButton m_nextButton = null;
    private JButton m_finishButton = null;
    private JButton m_cancelButton = null;
    private JButton m_helpButton = null;
    private JButton m_closeButton = null;
    public static final int BUTTON_BACK = 0;
    public static final int BUTTON_NEXT = 1;
    public static final int BUTTON_FINISH = 2;
    public static final int BUTTON_CANCEL = 3;
    public static final int BUTTON_HELP = 4;
    public static final int BUTTON_CLOSE = 5;

    public VWTaskWizardMainPanel(VWTaskWizardListener l) {
        if (l instanceof VWTaskWizardDialog) {
            this.m_mainFrame = (VWTaskWizardDialog)l;
        }
        this.m_wizardListener = l;
        this.initLayout();
    }

    public void setSystemExitOnClose(boolean exitOnClose) {
        this.m_bSystemExitOnClose = exitOnClose;
    }

    public void addWizardPanel(IVWTaskWizardPanel panel) {
        this.m_panelList.add(panel);
        this.m_mainPanel.add((Component)((JPanel)((Object)panel)), "" + this.m_panelList.size());
        if (this.m_panelList.size() == 1) {
            panel.refresh();
            this.setInstructions(panel.getInstructions());
        }
        this.updateButtonState();
    }

    public void setWizardSummaryPanel(IVWTaskWizardPanel panel) {
        this.m_summaryPanel = panel;
    }

    public void updateButtonState() {
        if (!this.m_bSummaryDisplayed) {
            IVWTaskWizardPanel panel = this.getCurrentPanel();
            if (panel instanceof IVWTaskWizardControl) {
                IVWTaskWizardControl ctrl = (IVWTaskWizardControl)((Object)panel);
                this.m_backButton.setEnabled(this.m_nPanelIndex > 0 && ctrl.allowButtonToBeEnabled(0));
                this.m_nextButton.setEnabled(this.m_nPanelIndex < this.m_panelList.size() - 1 && ctrl.allowButtonToBeEnabled(1));
                this.m_finishButton.setEnabled(this.m_nPanelIndex == this.m_panelList.size() - 1 && ctrl.allowButtonToBeEnabled(2));
            } else {
                this.m_backButton.setEnabled(this.m_nPanelIndex > 0);
                this.m_nextButton.setEnabled(this.m_nPanelIndex < this.m_panelList.size() - 1);
                this.m_finishButton.setEnabled(this.m_nPanelIndex == this.m_panelList.size() - 1);
            }
            if (!this.m_nextButton.isEnabled() && this.m_finishButton.isEnabled()) {
                this.setDefaultButton(this.m_finishButton);
            } else {
                this.setDefaultButton(this.m_nextButton);
            }
        } else {
            boolean allowCloseButton = true;
            if (this.m_summaryPanel instanceof IVWTaskWizardControl) {
                allowCloseButton = ((IVWTaskWizardControl)((Object)this.m_summaryPanel)).allowButtonToBeEnabled(5);
            }
            this.m_backButton.setEnabled(false);
            this.m_nextButton.setEnabled(false);
            this.m_finishButton.setEnabled(false);
            this.m_cancelButton.setVisible(false);
            this.m_closeButton.setVisible(allowCloseButton);
            this.setDefaultButton(this.m_closeButton);
        }
    }

    public void setConfirmOnCancel(boolean confirm) {
        this.m_bConfirmOnCancel = confirm;
    }

    public void setButtonVisible(int button, boolean visible) {
        switch (button) {
            case 0: {
                this.m_backButton.setVisible(visible);
                break;
            }
            case 1: {
                this.m_nextButton.setVisible(visible);
                break;
            }
            case 2: {
                this.m_finishButton.setVisible(visible);
                break;
            }
            case 3: {
                this.m_cancelButton.setVisible(visible);
                break;
            }
            case 4: {
                this.m_helpButton.setVisible(visible);
            }
        }
    }

    public void setButtonText(int button, String text) {
        switch (button) {
            case 0: {
                this.m_backButton.setText(text);
                break;
            }
            case 1: {
                this.m_nextButton.setText(text);
                break;
            }
            case 2: {
                this.m_finishButton.setText(text);
                break;
            }
            case 3: {
                this.m_cancelButton.setText(text);
                break;
            }
            case 4: {
                this.m_helpButton.setText(text);
            }
        }
    }

    public void actionPerformed(ActionEvent event) {
        try {
            Object object = event.getSource();
            if (object.equals(this.m_backButton)) {
                this.moveBack();
            } else if (object.equals(this.m_nextButton)) {
                this.moveNext();
            } else if (object.equals(this.m_finishButton)) {
                this.onFinish();
            } else if (object.equals(this.m_closeButton)) {
                if (this.m_bSystemExitOnClose) {
                    System.exit(0);
                } else {
                    this.setVisible(false);
                }
            } else if (object.equals(this.m_cancelButton)) {
                this.exitDialog();
            } else if (object.equals(this.m_helpButton)) {
                this.showHelp();
            }
        }
        catch (Exception e) {
            VWTaskCore.getInstance().displayError(e);
        }
    }

    public void windowClosing(WindowEvent event) {
        this.exitDialog();
    }

    private void onFinish() {
        Runnable finishAction = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                block14: {
                    try {
                        boolean bPassedValidation = true;
                        try {
                            VWTaskWizardMainPanel.this.validateCurrentPanel();
                        }
                        catch (Exception ex) {
                            bPassedValidation = false;
                            VWTaskCore.getInstance().displayError((Throwable)ex, false);
                        }
                        if (!bPassedValidation) break block14;
                        try {
                            VWTaskUtil.showWaitCursor(true, VWTaskCore.getInstance().getMainFrame());
                            VWTaskWizardMainPanel.this.m_wizardListener.handleFinish();
                            if (VWTaskWizardMainPanel.this.m_summaryPanel != null) {
                                VWTaskWizardMainPanel.this.displaySummaryPanel();
                            } else if (VWTaskWizardMainPanel.this.m_wizardListener instanceof JDialog) {
                                ((JDialog)((Object)VWTaskWizardMainPanel.this.m_wizardListener)).setVisible(false);
                            } else {
                                VWTaskWizardMainPanel.this.setVisible(false);
                            }
                        }
                        catch (Exception ex) {
                            VWTaskCore.getInstance().displayError(ex);
                        }
                        finally {
                            VWTaskUtil.showWaitCursor(false, VWTaskCore.getInstance().getMainFrame());
                        }
                    }
                    finally {
                        VWTaskWizardMainPanel.this.updateButtonState();
                    }
                }
            }
        };
        this.setDefaultButton(null);
        new Thread(finishAction).start();
    }

    private void setDefaultButton(JButton b) {
        if (this.getRootPane() != null) {
            this.getRootPane().setDefaultButton(b);
        } else {
            VWTaskCore.getInstance().getMainFrame().getRootPane().setDefaultButton(b);
        }
    }

    private void initLayout() {
        try {
            this.setLayout(new BorderLayout(0, 0));
            this.m_instructionsArea = new JTextArea(3, 2);
            this.m_instructionsArea.setEditable(false);
            this.m_instructionsArea.setLineWrap(true);
            this.m_instructionsArea.setWrapStyleWord(true);
            this.m_instructionsArea.setMargin(new Insets(1, 1, 1, 1));
            VWAccessibilityHelper.setAccessibility(this.m_instructionsArea, this, this.m_instructionsArea.getText(), this.m_instructionsArea.getText());
            this.m_instructionsScrollPane = new JScrollPane(this.m_instructionsArea);
            VWTaskUtil.updateComponentOrientation(this.m_instructionsScrollPane);
            this.add((Component)this.m_instructionsScrollPane, "First");
            this.add((Component)this.getMainPanel(), "Center");
            this.add((Component)this.getButtonPanel(), "Last");
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private JPanel getMainPanel() {
        if (this.m_mainPanel == null) {
            this.m_cardLayout = new CardLayout();
            this.m_mainPanel = new JPanel(this.m_cardLayout);
            this.m_panelList = new ArrayList();
            this.m_nPanelIndex = 0;
        }
        return this.m_mainPanel;
    }

    private JPanel getButtonPanel() {
        JPanel panel = null;
        panel = new JPanel(new FlowLayout());
        this.m_backButton = new JButton(VWResource.Back);
        panel.add(this.m_backButton);
        this.m_backButton.setEnabled(false);
        this.m_backButton.addActionListener(this);
        this.m_nextButton = new JButton(VWResource.Next);
        panel.add(this.m_nextButton);
        this.m_nextButton.addActionListener(this);
        this.m_finishButton = new JButton(VWResource.Finish);
        panel.add(this.m_finishButton);
        this.m_finishButton.setEnabled(false);
        this.m_finishButton.addActionListener(this);
        this.m_cancelButton = new JButton(VWResource.Cancel);
        panel.add(this.m_cancelButton);
        this.m_cancelButton.addActionListener(this);
        this.m_closeButton = new JButton(VWResource.Close);
        this.m_closeButton.setVisible(false);
        panel.add(this.m_closeButton);
        this.m_closeButton.addActionListener(this);
        this.m_helpButton = new JButton(VWResource.Help + "...");
        panel.add(this.m_helpButton);
        this.m_helpButton.addActionListener(this);
        return panel;
    }

    private void validateCurrentPanel() throws Exception {
        this.getCurrentPanel().performValidation();
    }

    private IVWTaskWizardPanel getCurrentPanel() {
        return (IVWTaskWizardPanel)this.m_panelList.get(this.m_nPanelIndex);
    }

    private IVWTaskWizardPanel getNextPanel() {
        if (this.m_nPanelIndex < this.m_panelList.size() - 1) {
            return (IVWTaskWizardPanel)this.m_panelList.get(this.m_nPanelIndex);
        }
        return null;
    }

    private void moveBack() {
        if (this.m_panelList != null && this.m_nPanelIndex > 0) {
            this.m_cardLayout.previous(this.m_mainPanel);
            --this.m_nPanelIndex;
            IVWTaskWizardPanel panel = this.getCurrentPanel();
            panel.refresh();
            this.setInstructions(panel.getInstructions());
            this.updateButtonState();
            this.updateButtonFocus();
            if (panel.skipThisPanel()) {
                this.moveBack();
            }
        }
    }

    private void moveNext() throws Exception {
        if (this.m_panelList != null && this.m_nPanelIndex < this.m_panelList.size() - 1) {
            boolean bPassedValidation = true;
            try {
                if (!this.getCurrentPanel().skipThisPanel()) {
                    this.validateCurrentPanel();
                }
            }
            catch (Exception ex) {
                bPassedValidation = false;
                VWTaskCore.getInstance().displayError((Throwable)ex, false);
            }
            if (bPassedValidation) {
                this.m_cardLayout.next(this.m_mainPanel);
                ++this.m_nPanelIndex;
                IVWTaskWizardPanel panel = this.getCurrentPanel();
                panel.refresh();
                this.setInstructions(panel.getInstructions());
                this.updateButtonState();
                if (panel.skipThisPanel()) {
                    this.moveNext();
                }
            }
            this.updateButtonFocus();
        }
    }

    private void displaySummaryPanel() {
        if (this.m_summaryPanel == null) {
            return;
        }
        this.remove(this.m_mainPanel);
        this.add((Component)((JPanel)((Object)this.m_summaryPanel)), "Center");
        this.m_summaryPanel.refresh();
        this.setInstructions(this.m_summaryPanel.getInstructions());
        this.m_bSummaryDisplayed = true;
        this.updateButtonState();
        this.m_closeButton.requestFocus();
    }

    private void updateButtonFocus() {
        if (this.m_nextButton.isEnabled()) {
            this.m_nextButton.requestFocus();
        } else if (this.m_finishButton.isEnabled()) {
            this.m_finishButton.requestFocus();
        } else if (this.m_backButton.isEnabled()) {
            this.m_backButton.requestFocus();
        }
    }

    private void setInstructions(String instructions) {
        if (instructions != null) {
            this.m_instructionsArea.setText(instructions);
            this.m_instructionsScrollPane.setVisible(true);
            this.m_instructionsArea.setVisible(true);
        } else {
            this.m_instructionsScrollPane.setVisible(false);
            this.m_instructionsArea.setVisible(false);
        }
    }

    private void showHelp() {
        VWHelp.displayPage(this.getCurrentPanel().getHelpPath());
    }

    protected void exitDialog() {
        try {
            if (this.m_bConfirmOnCancel) {
                Toolkit.getDefaultToolkit().beep();
                if (!VWTaskCore.getInstance().displayConfirmation(VWResource.CancelMessage)) {
                    return;
                }
            }
            if (this.m_mainFrame != null) {
                this.m_mainFrame.setVisible(false);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }
}

